clc; clear; 

%% Problem Data



load("NDX_data.mat");


n = length(mu);
Q = 10*Sigma;
h = -mu';


x0 = ones(n,1)*1/n;

  




%% Algorithm

alpha_start = 1/max(eig(Q));
% alpha_start = 100;

% Projected grad descent
[x_pgd,data,k] = Port_Fix(@(x)(objective(x,Q,h)),Q,h,x0,alpha_start);
% [x_pgd,data,k] = Port_Arm(@(x)(objective(x,Q,h)),Q,h,x0,alpha_start);


fprintf('Function value %.4e \n',0.5*x_pgd'*Q*x_pgd + h'*x_pgd)


%% Plotting

% solve the GAP problem
options = optimoptions('linprog','OptimalityTolerance',1e-8,'Display','off');

GAP = ones(k,1);
for i = 1:k
 
    GAP(i)=norm(project_simplex(data.x(:,i)-Q*data.x(:,i)-h)-data.x(:,i));

end


fprintf('Final GAP value %.4e \n',GAP(end));









